from Bonds import *

class BondLattice:
    def __init__(self, nSpinsX, nSpinsY):
        self.nSpinsX = nSpinsX
        self.nSpinsY = nSpinsY
        
        self.visualBondArray = [ None ] * (nSpinsX+1)                               # a vector of null elements, nSpinsX long
        for x in range(nSpinsX+1):
            self.visualBondArray[x] = [0] * (nSpinsY+1)                             # a vector of zeros nSpinsY long
            for y in range(nSpinsY+1):
                self.visualBondArray[x][y] = Bonds()


        self.addBonds()


                

    ## BOND METHODS

    def addBonds(self):       
        for x in range(self.nSpinsX+1):
            for y in range(self.nSpinsY+1):              
                boxxPos = (x-self.nSpinsX,y-self.nSpinsY+1.0/2.0,0.0)
                length = 0.5
                width = 0.05
                height = 0.05
                self.visualBondArray[x][y].setBoxesX(boxxPos, length, width, height)

                boxyPos = (x-self.nSpinsX+1.0/2.0,y-self.nSpinsY,0.0)
                length = 0.05
                width = 0.05
                height = 0.5
                self.visualBondArray[x][y].setBoxesY(boxyPos, length, width, height)

            
    def updateBonds(self, nLattice):
        for x in range(self.nSpinsX+1):
            for y in range(self.nSpinsY+1):
                z = nLattice.returnBondXEnergies()[x][y]*nLattice.returnCouplingX()[(x-1)%self.nSpinsX][(x)%self.nSpinsX]
                colorx = (z,0.0,1.0-z)
                
                z = nLattice.returnBondYEnergies()[x][y]*nLattice.returnCouplingY()[(y-1)%self.nSpinsY][(y)%self.nSpinsY]
                colory = (z,0.0,1.0-z)
                
                self.visualBondArray[x][y].setColors(colorx,colory)
                

    def toggleBonds(self):
        for x in range(self.nSpinsX+1):
            for y in range(self.nSpinsY+1):
                self.visualBondArray[x][y].toggleBondVisibility()
                

